const char* WEB_HTML = R"rawliteral(
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name='author' content='Teguh Sakura (teguh.sakura@yahoo.com)'>
    <meta name='description' content='Alat Ukur Kesehatan Tanah berbasis Arduino'>
    <title>Alat Ukur Kesehatan Tanah</title>
    <style>
        body {
            font-family: 'Inter', sans-serif;
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            background-color: #f0f4f8;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            padding: 20px;
        }

        .container {
            max-width: 600px;
            width: 100%;
            background-color: #ffffff;
            border-radius: 12px;
            box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
            padding: 24px;
            text-align: center;
        }
        @media (min-width: 640px) {
            .container {
                padding: 32px;
            }
        }

        h1 {
            font-size: 30px;
            font-weight: 800;
            color: #1f2937;
            margin-bottom: 24px;
        }
        @media (min-width: 640px) {
            h1 {
                font-size: 36px;
            }
        }

        .grid-container {
            display: grid;
            grid-template-columns: 1fr;
            gap: 16px;
            margin-bottom: 32px;
        }
        @media (min-width: 640px) {
            .grid-container {
                grid-template-columns: repeat(2, 1fr);
            }
            .ph-card {
                grid-column: span 2 / span 2;
            }
        }

        .card {
            border-radius: 8px;
            padding: 16px;
            box-shadow: 0 1px 2px 0 rgba(0, 0, 0, 0.05);
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
        }

        .temp-card {
            background-color: #eff6ff;
            border: 1px solid #bfdbfe;
        }
        .temp-text { color: #1d4ed8; }
        .temp-value { color: #1e3a8a; }

        .moisture-card {
            background-color: #f0fdf4;
            border: 1px solid #bbf7d0;
        }
        .moisture-text { color: #16a34a; }
        .moisture-value { color: #14532d; }

        .ph-card {
            background-color: #fffbeb;
            border: 1px solid #fde68a;
        }
        .ph-text { color: #b45309; }
        .ph-value { color: #854d0e; }

        .plant-rec-section {
            background-color: #faf5ff;
            border: 1px solid #e9d5ff;
            border-radius: 8px;
            padding: 24px;
            box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
        }
        .plant-rec-title {
            font-size: 20px;
            font-weight: 600;
            color: #6d28d9;
            margin-bottom: 12px;
        }
        .plant-rec-value {
            font-size: 48px;
            font-weight: 800;
            color: #4c1d95;
            line-height: 1.25;
        }

        .value-text-lg { font-size: 18px; }
        .value-text-4xl { font-size: 36px; }

        .mt-2 { margin-top: 8px; }

        .flex-center-row {
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .icon {
            width: 24px;
            height: 24px;
            margin-right: 8px;
            vertical-align: middle;
            stroke: currentColor;
            fill: none;
            stroke-width: 2;
            stroke-linecap: round;
            stroke-linejoin: round;
        }

        .fade-in {
            animation: fadeIn 0.5s ease-in-out;
        }
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }
    </style>
</head>
<body class="bg-gray-100 flex items-center justify-center min-h-screen p-4">
    <div class="container">
        <h1>Alat Ukur Kesehatan Tanah</h1>
        <hr><br>
        <div class="grid-container">
            <div class="card temp-card">
                <p class="value-text-lg font-semibold temp-text flex-center-row">
                    <!-- Temperature Icon (Lucide: Thermometer) -->
                    <svg xmlns="http://www.w3.org/2000/svg" class="icon" viewBox="0 0 24 24">
                        <path d="M14 14.76V3.5a2.5 2.5 0 0 0-5 0v11.26a4.5 4.5 0 1 0 5 0z"/>
                    </svg>
                    Suhu
                </p>
                <p id="temperature" class="value-text-4xl font-bold temp-value mt-2">--°C</p>
            </div>

            <div class="card moisture-card">
                <p class="value-text-lg font-semibold moisture-text flex-center-row">
                    <!-- Moisture Icon (Lucide: Droplets) -->
                    <svg xmlns="http://www.w3.org/2000/svg" class="icon" viewBox="0 0 24 24">
                        <path d="M12 2.69l5.66 5.66a8 8 0 1 1-11.32 0z"/>
                    </svg>
                    Kelembaban
                </p>
                <p id="moisture" class="value-text-4xl font-bold moisture-value mt-2">--%</p>
            </div>

            <div class="card ph-card">
                <p class="value-text-lg font-semibold ph-text">pH Tanah</p>
                <p id="ph" class="value-text-4xl font-bold ph-value mt-2">--</p>
            </div>
        </div>

        <div class="plant-rec-section">
            <p class="plant-rec-title">Rekomendasi Tanaman:</p>
            <p id="plant-recommendation" class="plant-rec-value">Memuat...</p>
        </div>

        <br><hr><br>

        <div class="plant-rec-section">
            <font color='blue'><b>Teguh Sakura</b>&trade; </font><br>
            <font color='green'> &#9993; <b>teguh.sakura@yahoo.com | toko.teguh.sakura@gmail.com </b> </font><br>
        </div>
    </div>

    <script>
        async function fetchData() {
            try {
                const response = await fetch('/data');
                const data = await response.json();

                // Update HTML elements with new data
                document.getElementById('temperature').textContent = data.temperature.toFixed(1) + '°C';
                document.getElementById('moisture').textContent = data.moisture + '%';
                document.getElementById('ph').textContent = data.ph.toFixed(1);
                document.getElementById('plant-recommendation').textContent = data.plant;

                // Optional: Add a subtle fade-in effect on update
                const elementsToUpdate = ['temperature', 'moisture', 'ph', 'plant-recommendation'];
                elementsToUpdate.forEach(id => {
                    const el = document.getElementById(id);
                    el.classList.remove('fade-in');
                    void el.offsetWidth; // memicu reflow untuk mengulang animasi
                    el.classList.add('fade-in');
                });

            } catch (error) {
                console.error('Gagal memuat data:', error);
                document.getElementById('plant-recommendation').textContent = 'Gagal membuat data.';
            }
        }

        // Ambil data saat halaman di buka pertama kali
        document.addEventListener('DOMContentLoaded', fetchData);

        // ambil data setiap 5 detik (bisa diganti)
        setInterval(fetchData, 5000);
    </script>
</body>
</html>
)rawliteral";
